<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xsl:stylesheet  [
<!ENTITY ndash "&#8211;">
]>
<xsl:stylesheet
	version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:com="http://www.sec.gov/edgar/common"
	xmlns:dei="http://www.sec.gov/edgar/dei"
	xmlns:invest="http://www.sec.gov/edgar/invest"
	xmlns:n1="http://www.sec.gov/edgar/nmfp"
	xmlns:part1="http://www.sec.gov/edgar/nmfpfund"
	xmlns:part2="http://www.sec.gov/edgar/nmfpsecurities"
	xmlns:ratings="http://www.sec.gov/edgar/ratings"
	xmlns:rr="http://www.sec.gov/edgar/rr"
	xmlns:sccom="http://www.sec.gov/edgar/sccommon"
	xmlns:state="http://www.sec.gov/edgar/statecodes"
	xmlns:us-gaap="http://www.sec.gov/edgar/us-gaap">

	<xsl:output method="xml" indent="yes"
		encoding="UTF-8" doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN"
		doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd" />

	<xsl:template match="/">
		<html>
			<xsl:call-template name="header"/>
			<body lang="en-US" text="#000000" bgcolor="#ffffff">
			<div id="n-mfp_x01">
				<xsl:call-template name="masthead"/>
				<xsl:apply-templates />
			</div>
			</body>
		</html>
	</xsl:template>

	<xsl:template name="masthead">
      <div id="masthead">
        <div id="sec">
          <div id="seccontainer">
            <p class="heading">UNITED STATES</p>
            <p class="heading">SECURITIES AND EXCHANGE COMMISSION</p>
            <p class="heading">WASHINGTON, DC 20549</p>
          </div>
        </div>
        <div id="formname">
          <div id="formnamecontainer">
            <p class="heading">FORM N-MFP</p>
            <p class="heading">MONTHLY SCHEDULE OF PORTFOLIO HOLDINGS</p>
            <p class="heading">OF MONEY MARKET FUNDS</p>
          </div>
        </div>
      </div>
	</xsl:template>

	<xsl:template name="header">
		<head>
			<title>FORM N-MFP</title>
			<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1"/>
			<link rel="stylesheet" href="Formstyle/N-MFP_X01.css"/>
		</head>
	</xsl:template>

	<xsl:template name="BooleanOutput">
		<xsl:param name="value"/>
		
		<xsl:choose>
			<xsl:when test="$value = 'Y' or $value = 'y'"><xsl:text>Yes</xsl:text></xsl:when>
			<xsl:otherwise><xsl:text>No</xsl:text></xsl:otherwise>
		</xsl:choose>
		
	</xsl:template>

	<xsl:template match="n1:edgarSubmission">
		<div id="submissioninfo">
			<xsl:apply-templates select="n1:isThisElectronicCopyOfPaperFormat" />
			<xsl:apply-templates select="n1:DocumentPeriodEndDate" />
			<xsl:apply-templates select="n1:EntityCentralIndexKey" />
			<xsl:apply-templates select="n1:seriesId" />
			<xsl:apply-templates	select="n1:totalClassesInSeries" />
			<xsl:apply-templates	select="n1:isThisFinalFiling" />
			<xsl:apply-templates	select="n1:hasFundAcquiredOrMergedWithAnotherFundSinceLastFiling" />
		</div>

		<div id="part1">
			<xsl:apply-templates select="n1:seriesLevelInformation"/>
			<xsl:apply-templates select="n1:classLevelInformationList"/>
		</div>
		
		<div id="part2">
			<xsl:apply-templates select="n1:scheduleOfPortfolioSecuritiesList"/>
      </div>
	</xsl:template>

	<xsl:template match="n1:isThisElectronicCopyOfPaperFormat">
	<p>
		Is this an electronic copy of an official filing submitted in paper
		format?
		<span id="data">
			<xsl:call-template name="BooleanOutput">
				<xsl:with-param name="value">
					<xsl:value-of select="."></xsl:value-of>
				</xsl:with-param>
			</xsl:call-template>
		</span>
	</p>
	</xsl:template>

	<xsl:template match="n1:DocumentPeriodEndDate">
		<p>
			Report date:
			<span	id="data">
				<xsl:call-template name="DateToMonthNameLong">
					<xsl:with-param name="sDate" select="."/>
				</xsl:call-template>
				<xsl:text> </xsl:text>
				<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), '00')" />
				<xsl:text>, </xsl:text>
				<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), '0000')" />
			</span>
		</p>

	</xsl:template>
	
	<xsl:template match="n1:EntityCentralIndexKey">
			<p>CIK Number of Registrant: <span id="data"><xsl:value-of select="."/></span></p>
	</xsl:template>
	
	<xsl:template match="n1:seriesId">
			<p>EDGAR Series Identifier: <span id="data"><xsl:value-of select="."/></span></p>
	</xsl:template>
	
	<xsl:template match="n1:totalClassesInSeries">
			<p>Total number of share classes in the series: <span id="data"><xsl:value-of select="."/></span></p>
	</xsl:template>
	
	<xsl:template match="n1:isThisFinalFiling">
			<p>Do you anticipate this will be the fund's final filing on Form N-MFP?
				<span id="data">
					<xsl:call-template name="BooleanOutput">
						<xsl:with-param name="value">
							<xsl:value-of select="."></xsl:value-of>
						</xsl:with-param>
					</xsl:call-template>
				</span></p>

			<xsl:if test=". = 'Y' or . = 'y'">
			<blockquote>
				<xsl:apply-templates select="../n1:isFundLiquidating" />
				<xsl:apply-templates select="../n1:isFundMergingWithOrBeingAcquiredByAnotherFund" />
			</blockquote>
			</xsl:if>
				
	</xsl:template>
	
	<xsl:template match="n1:isFundLiquidating">
		<p>Is the fund liquidating? <span id="data">
			<xsl:call-template name="BooleanOutput">
				<xsl:with-param name="value">
					<xsl:value-of select="."></xsl:value-of>
				</xsl:with-param>
			</xsl:call-template></span></p>
	</xsl:template>

	<xsl:template match="n1:isFundMergingWithOrBeingAcquiredByAnotherFund">
		<p>Is the fund merging with, or being acquired by, another fund?
			<span id="data">
				<xsl:call-template name="BooleanOutput">
					<xsl:with-param name="value">
						<xsl:value-of select="."></xsl:value-of>
					</xsl:with-param>
				</xsl:call-template>
			</span>
		</p>
		<xsl:if test=". = 'Y' or . = 'y'">
			<xsl:apply-templates select="../n1:successorFundList"/>
		</xsl:if>
	</xsl:template>
	
	<xsl:template match="n1:successorFundList">
	<div id="successorfundinfo">
		<h1>Successor Fund Information</h1>
		<table>
			<col />
			<col />
			<col />
			<tr>
				<th>
					<p>CIK</p>
				</th>
				<th>
					<p>Securities Act file number</p>
				</th>
				<th>
					<p>EDGAR series identifier</p>
				</th>
			</tr>
			<xsl:apply-templates/>
		</table>
	</div>
	
	</xsl:template>

	<xsl:template match="n1:fund">
	<tr>
		<td>
			<p>
				<xsl:value-of select="./n1:EntityCentralIndexKey" />
			</p>
		</td>
		<td>
			<p>
				<xsl:value-of select="./n1:ContainedFileInformationFileNumber" />
			</p>
		</td>
		<td>
			<p>
				<xsl:value-of select="./n1:seriesIdentifier" />
			</p>
		</td>
	</tr>
	</xsl:template>

	<xsl:template
		match="n1:hasFundAcquiredOrMergedWithAnotherFundSinceLastFiling">
		<p>
			If this is not a final filing, has the fund acquired or merged
			with
			another fund since the last filing?
			<span id="data">
				<xsl:value-of select="." />
			</span>
		</p>

		<xsl:if test=". = 'Y' or . = 'y'">
			<xsl:apply-templates select="./n1:acquiredMergedFundList"/>
		</xsl:if>
	</xsl:template>

	<xsl:template
		match="n1:acquiredMergedFundList">
		<div
			id="acquiredmergedinfo">
			<h1>Acquired or Merged Fund Information</h1>
			<table>
				<col />
				<col />
				<col />
				<tr>
					<th>
						<p>CIK</p>
					</th>
					<th>
						<p>Securities
							Act file number</p>
					</th>
					<th>
						<p>EDGAR
							series identifier</p>
					</th>
				</tr>
				<xsl:apply-templates/>
			</table>
		</div>
	</xsl:template>

	<xsl:template match="part1:ContainedFileInformationFileNumber">
		<p>Item 1. Securities Act File Number: <xsl:value-of select="."/></p>
	</xsl:template>

	<xsl:template match="part1:adviser | part1:subAdviser">
		<tr>
			<td>
				<p><xsl:value-of select="./part1:adviserName" /></p>
			</td>
			<td>
				<p><xsl:value-of select="./part1:adviserFileNumber" /></p>
			</td>
		</tr>
	</xsl:template>

	<xsl:template match="part1:investmentAdviserList">
		<p>Item 2. Investment Adviser</p>
		<div id="investmentadvisors">
			<table>
				<col />
				<col />
				<tr>
					<th>
						<p>Investment Adviser</p>
					</th>
					<th>
						<p>SEC file number of investment adviser</p>
					</th>
				</tr>
				<xsl:apply-templates/>
			</table>
		</div>
	</xsl:template>

	<xsl:template match="part1:subAdviserList">
		<xsl:if test="count(part1:subAdviser) > 0">
			<p>Item 3. Sub-Adviser</p>
			<div id="investmentadvisors">
				<table>
					<col />
					<col />
					<tr>
						<th>
							<p>Sub-Adviser</p>
						</th>
						<th>
							<p>SEC file number of each sub-adviser</p>
						</th>
					</tr>
					<xsl:apply-templates />
				</table>
			</div>
		</xsl:if>
	</xsl:template>

	<xsl:template match="part1:independentPublicAccountant">
		<p>Item 4. Independent Public Accountant</p>
		<div id="investmentadvisors">
			<table>
				<col />
				<col />
				<tr>
					<td>
						<p><xsl:value-of select="./part1:name"/></p>
					</td>
					<td>
						<p><xsl:value-of select="./part1:city"/>, <xsl:value-of select="./part1:state"/></p>
					</td>
				</tr>
			</table>
		</div>
	</xsl:template>

	<xsl:template match="part1:administrator">
		<tr>
			<td>
				<xsl:apply-templates />
			</td>
		</tr>
	</xsl:template>

	<xsl:template match="part1:administratorList">
		<xsl:if test="count(./part1:administrator) > 0">
			<p>Item 5. Administrator</p>
			<div id="investmentadvisors">
				<table>
					<col />
					<tr>
						<th>
							<p>Administrator</p>
						</th>
					</tr>
					<xsl:apply-templates />
				</table>
			</div>
		</xsl:if>
	</xsl:template>

	<xsl:template match="part1:transferAgent">
		<tr>
			<td>
				<p><xsl:value-of select="part1:name"/></p>
			</td>
			<td>
				<p><xsl:value-of select="part1:EntityCentralIndexKey"/></p>
			</td>
			<td>
				<p><xsl:value-of select="part1:fileNumber"/></p>
			</td>
		</tr>

	</xsl:template>

	<xsl:template match="part1:transferAgentList">
		<xsl:if test="count(./part1:transferAgent) > 0">
			<p>Item 6. Transfer Agent</p>
			<div id="investmentadvisors">
				<table>
					<col />
					<col />
					<col />
					<tr>
						<th>
							<p>Transfer Agent</p>
						</th>
						<th>
							<p>CIK number</p>
						</th>
						<th>
							<p>SEC file number of transfer agent</p>
						</th>
					</tr>
					<xsl:apply-templates/>
				</table>
			</div>
		</xsl:if>
	</xsl:template>

	<xsl:template match="part1:masterFund">
		<div id="feederfund">
			<h1>Master Fund Information</h1>
			<table>
				<col />
				<col />
				<col />
				<tr>
					<th>
						<p>CIK</p>
					</th>
					<th>
						<p>Name</p>
					</th>
					<th>
						<p>Securities Act file number</p>
					</th>
					<th>
						<p>EDGAR series identifier</p>
					</th>
				</tr>
				<tr>
					<td>
						<p><xsl:value-of select="part1:EntityCentralIndexKey"/></p>
					</td>
					<td>
						<p><xsl:value-of select="part1:EntityRegistrantName"/></p>
					</td>
					<td>
						<p><xsl:value-of select="part1:ContainedFileInformationFileNumber"/></p>
					</td>
					<td>
						<p><xsl:value-of select="part1:seriesIdentifier"/></p>
					</td>
				</tr>

			</table>
		</div>
	</xsl:template>

	<xsl:template match="part1:isThisFeederFund">
		<p>Item 7. Master-Feeder Funds. Is this a feeder fund?
			<xsl:call-template name="BooleanOutput"> 
				<xsl:with-param name="value">
					<xsl:value-of select="."/>
				</xsl:with-param>
			</xsl:call-template>
		</p>
		<xsl:if test=". = 'Y' or . = 'y'">
			<xsl:apply-templates select="../part1:masterFund"/>
		</xsl:if>
	</xsl:template>

	<xsl:template match="part1:feederFund">
		<tr>
			<td>
				<p><xsl:value-of select="part1:EntityCentralIndexKey" /></p>
			</td>
			<td>
				<p><xsl:value-of select="part1:EntityRegistrantName" /></p>
			</td>
			<td>
				<p><xsl:value-of select="part1:ContainedFileInformationFileNumber" /></p>
			</td>
			<td>
				<p><xsl:value-of select="part1:seriesIdentifier" /></p>
			</td>
		</tr>
	</xsl:template>

	<xsl:template match="part1:feederFundList">
		<div id="masterfund">
			<h1>Feeder Fund Information</h1>
			<table>
				<col />
				<col />
				<col />
				<tr>
					<th>
						<p>CIK</p>
					</th>
					<th>
						<p>Name</p>
					</th>
					<th>
						<p>Securities Act file number</p>
					</th>
					<th>
						<p>EDGAR series identifier</p>
					</th>
				</tr>
				<xsl:apply-templates/>
			</table>
		</div>	</xsl:template>

	<xsl:template match="part1:isThisMasterFund">
		<p>Item 8. Master-Feeder Funds. Is this a master fund?
			<xsl:call-template name="BooleanOutput">
				<xsl:with-param name="value">
					<xsl:value-of 	select="." />
				</xsl:with-param>
			</xsl:call-template>
		</p>
		<xsl:if test=". = 'Y' or . = 'y'">
			<xsl:apply-templates select="../part1:feederFundList"/>
		</xsl:if>

	</xsl:template>

	<xsl:template match="part1:isThisSeriesPrimarilyUsedToFundInsuranceCompanySeperateAccounts">
		<p>Item 9. Is this series primarily used to fund insurance company separate accounts?
			<xsl:call-template name="BooleanOutput">
				<xsl:with-param name="value">
					<xsl:value-of 	select="." />
				</xsl:with-param>
			</xsl:call-template>
		</p>
	</xsl:template>

	<xsl:template match="part1:InvestmentTypeDomain">
		<p>Item 10. Category: <xsl:apply-templates/>
		</p>
	</xsl:template>

	<xsl:template match="part1:dollarWeightedAveragePortfolioMaturity">
		<p>Item 11. Dollar weighted average portfolio maturity: <xsl:apply-templates/>
		</p>
	</xsl:template>

	<xsl:template match="part1:dollarWeightedAverageLifeMaturity">
		<p>Item 12. Dollar weighted average life maturity: <xsl:apply-templates/>
		</p>
	</xsl:template>

	<xsl:template match="part1:AvailableForSaleSecuritiesAmortizedCost">
		<p>Item 13. Total value of portfolio securities at amortized cost: <xsl:apply-templates/>
		</p>
	</xsl:template>

	<xsl:template match="part1:OtherAssets">
		<p>Item 14. Total value of other assets:
			<xsl:value-of select="format-number(., '$##,###,###,###,###.##')"/>
		</p>
	</xsl:template>

	<xsl:template match="part1:Liabilities">
		<p>Item 15. Total value of liabilities:
			<xsl:value-of select="format-number(., '$##,###,###,###,###.##')"/>
		</p>
	</xsl:template>

	<xsl:template match="part1:AssetsNet">
		<p>Item 16. Net assets of the series:
			<xsl:value-of select="format-number(., '$##,###,###,###,###.##')"/>
		</p>
	</xsl:template>

	<xsl:template match="part1:MoneyMarketSevenDayYield">
		<p>Item 17. 7-day gross yield: <xsl:apply-templates/>
		</p>
	</xsl:template>

	<xsl:template match="part1:seriesShadowPrice">
		<p>
			Item 18. Shadow Price of the Series. Net asset
			value per share most recent calculated using
			available market quotations (or an appropriate
			substitute that reflects current market
			conditions).
            </p>
		<div id="shadowprice">
			<table>
				<tr>
					<th>
						<p><br /></p>
					</th>
					<th>
						<p>Net Asset Value per Share</p>
					</th>
					<th>
						<p>Date Calculated</p>
					</th>
				</tr>
				<tr>
					<td>
						<p>Including capital support agreement</p>
					</td>
					<td>
						<p><xsl:value-of select="./part1:netValuePerShareIncludingCapitalSupportAgreement"/></p>
					</td>
					<td>
						<p><xsl:value-of select="./part1:dateCalculatedFornetValuePerShareIncludingCapitalSupportAgreement"/></p>
					</td>
				</tr>
				<tr>
					<td>
						<p>Excluding capital support agreement</p>
					</td>
					<td>
						<p><xsl:value-of select="./part1:netValuePerShareExcludingCapitalSupportAgreement"/></p>
					</td>
					<td>
						<p>
							<xsl:value-of select="././part1:dateCalculatedFornetValuePerShareExcludingCapitalSupportAgreement"/>
						</p>
					</td>
				</tr>
			</table>
		</div>
	</xsl:template>

	<xsl:template match="part1:classLevelInformation">
		<p>Item 19. EDGAR Class Identifier: <xsl:value-of select="./part1:classId"/></p>
		<p>Item 20. Minimum Initial Investment: <xsl:value-of select="format-number(./part1:minInitialInvestment, '$##,###,###,###,###.##')"/></p>
		<p>Item 21. Net assets of the Class: <xsl:value-of select="format-number(./part1:netAssetsOfClass, '$##,###,###,###,###.##')"/></p>
		<p>Item 22. Net asset value per share for purposes
			of distributions, redemptions, and repurchases:
			<xsl:value-of select="format-number(./part1:netAssetValuePerShare, '$##,###,###,###,###.##')"/></p>
		<p>Item 23. Net shareholder flow activity for themonth ended: <xsl:value-of select="./part1:netShareholderFlowActivityForMonthEnded"/></p>
		<div id="netshareholderflow">
			<table>
				<col />
				<col />
				<tr>
					<td>
						<p>Gross subscriptions for the month ended(including dividend reinvestments):</p>
					</td>
					<td>
						<p>
							<xsl:value-of select="./part1:grossSubscriptionsForMonthEnded"/>
						</p>
					</td>
				</tr>
				<tr>
					<td>
						<p>Gross redemptions for the month ended:</p>
					</td>
					<td>
						<p>
							<xsl:value-of select="./part1:grossRedemptionsForMonthEnded"/>
						</p>
					</td>
				</tr>
			</table>
		</div>
		<p>Item 24. 7-day net yield: <xsl:value-of select="./part1:sevenDayNetYield"/></p>
		<p>Item 25. Shadow Price of Each Class. Net asset
			value per share most recent calculated using
			available market quotations (or an appropriate
			substitute that reflects current market
			conditions)</p>
		<div id="shadowpricetable">
			<table>
				<col />
				<col />
				<tr>
					<th>
						<p>
							<br />
						</p>
					</th>
					<th>
						<p>Net Asset Value per Share</p>
					</th>
					<th>
						<p>Date Calculated</p>
					</th>
				</tr>
				<tr>
					<td>
						<p>Including the value of any capital support agreement:</p>
					</td>
					<td>
						<p><xsl:value-of select="./part1:classShadowPrice/part1:netAssetValuePerShareIncludingCapitalSupportAgreement/part1:value"/></p>
					</td>
					<td>
						<p><xsl:value-of select="./part1:classShadowPrice/part1:netAssetValuePerShareIncludingCapitalSupportAgreement/part1:dateAsOfWhichValueWasCalculated"/></p>
					</td>
				</tr>
				<tr>
					<td>
						<p>Excluding the value of any capital support agreement:</p>
					</td>
					<td>
						<p><xsl:value-of select="./part1:classShadowPrice/part1:netAssetValuePerShareExcludingCapitalSupportAgreement/part1:value"/></p>
					</td>
					<td>
						<p><xsl:value-of select="./part1:classShadowPrice/part1:netAssetValuePerShareExcludingCapitalSupportAgreement/part1:dateAsOfWhichValueWasCalculated"/></p>
					</td>
				</tr>
			</table>
		</div>
	</xsl:template>

	<xsl:template match="n1:classLevelInformationList">
		<div class="class">
			<p class="heading2">B. Class-Level Information.</p>
			<div class="classes">
         	<xsl:apply-templates/>
         </div>
		</div>	
   </xsl:template>

	<xsl:template match="n1:seriesLevelInformation">
        <p class="heading1">Part 1: Information about the Fund</p>
        <div class="series">
          <p class="heading2">A. Series-Level Information</p>
          <xsl:apply-templates select="part1:ContainedFileInformationFileNumber"/>
          <xsl:apply-templates select="part1:investmentAdviserList"/>
          <xsl:apply-templates select="part1:subAdviserList"/>
          <xsl:apply-templates select="part1:independentPublicAccountant"/>
          <xsl:apply-templates select="part1:administratorList"/>
          <xsl:apply-templates select="part1:transferAgentList"/>
          <xsl:apply-templates select="part1:isThisFeederFund"/>
          <xsl:apply-templates select="part1:isThisMasterFund"/>
          <xsl:apply-templates select="part1:isThisSeriesPrimarilyUsedToFundInsuranceCompanySeperateAccounts"/>
          <xsl:apply-templates select="part1:InvestmentTypeDomain"/>
          <xsl:apply-templates select="part1:dollarWeightedAveragePortfolioMaturity"/>
          <xsl:apply-templates select="part1:dollarWeightedAverageLifeMaturity"/>
          <xsl:apply-templates select="part1:AvailableForSaleSecuritiesAmortizedCost"/>
          <xsl:apply-templates select="part1:OtherAssets"/>
          <xsl:apply-templates select="part1:Liabilities"/>
          <xsl:apply-templates select="part1:AssetsNet"/>
          <xsl:apply-templates select="part1:MoneyMarketSevenDayYield"/>
          <xsl:apply-templates select="part1:seriesShadowPrice"/>
			</div>
			
	</xsl:template>

	<xsl:template match="part2:repurchaseAgreementList">
		<xsl:for-each select="./part2:RepurchaseAgreement">
			<tr>
				<td>
					<p><xsl:value-of select="./part2:InvestmentIssuer" /></p>
				</td>
				<td>
					<p><xsl:value-of select="./part2:InvestmentMaturityDate" /></p>
				</td>
				<td>
					<p><xsl:value-of select="./part2:CR" /></p>
				</td>
				<td>
					<p><xsl:value-of select="./part2:InvestmentTypeDomain" />
					<xsl:if test="string-length(./part2:categoryOfInvestmentDesc) > 0">
						<xsl:text> - </xsl:text><xsl:value-of select="./part2:categoryOfInvestmentDesc" />
					</xsl:if>
					</p>
				</td>
				<td>
					<p><xsl:value-of select="format-number(./part2:AssetsSoldUnderAgreementsToRepurchaseCarryingAmounts, '$##,###,###,###,###.##')" /></p>
				</td>
				<td>
					<p><xsl:value-of select="format-number(./part2:CashCollateralForBorrowedSecurities, '$##,###,###,###,###.##')" /></p>
				</td>
			</tr>
		</xsl:for-each>
	</xsl:template>

	<xsl:template name="part2:isFundTreatingAsAcquisitionUnderlyingSecurities">
		<p>
			Item 32. If the security is a Repurchase agreement: is fund treating the acquisition of the repurchase agreement as the aquisition of the underlying securities (i.e. collateral) for the purposes of portfolio diversification under rule 2a-7?
			<xsl:call-template name="BooleanOutput">
				<xsl:with-param name="value">
					<xsl:value-of select="./part2:isFundTreatingAsAcquisitionUnderlyingSecurities" />
				</xsl:with-param>
			</xsl:call-template>
		</p>

		<xsl:if test="./part2:isFundTreatingAsAcquisitionUnderlyingSecurities = 'Y' or ./part2:isFundTreatingAsAcquisitionUnderlyingSecurities = 'y'">
			<table>
				<col />
				<col />
				<col />
				<col />
				<col />
				<col />
				<tr>
					<th>
						<p>Name of the issuer</p>
					</th>
					<th>
						<p>Maturity date</p>
					</th>
					<th>
						<p>Coupon or yield</p>
					</th>
					<th>
						<p>Category of investment</p>
					</th>
					<th>
						<p>Principal amount</p>
					</th>
					<th>
						<p>Value of collateral</p>
					</th>
				</tr>
				<xsl:apply-templates select="./part2:repurchaseAgreementList"/>
			</table>
		</xsl:if>
	</xsl:template>

	<xsl:template name="part2:CUSIPMember">
		<p>Item 28. The CUSIP (optional):
			<xsl:call-template name="OutputOptional">
				<xsl:with-param name="value">
					<xsl:value-of select="./part2:CUSIPMember"></xsl:value-of>
				</xsl:with-param>
			</xsl:call-template>
		</p>
	</xsl:template>

	<xsl:template name="part2:InvestmentIdentifier">
		<p>Item 29. Other unique identifier (optional): 
			<xsl:call-template name="OutputOptional">
				<xsl:with-param name="value">
					<xsl:value-of select="./part2:InvestmentIdentifier"></xsl:value-of>
				</xsl:with-param>
			</xsl:call-template>
		</p>
	</xsl:template>

	<xsl:template name="part2:EntityCentralIndexKey">
		<p>Item 30. The CIK of the issuer (optional):
			<xsl:call-template name="OutputOptional">
				<xsl:with-param name="value">
					<xsl:value-of select="./part2:EntityCentralIndexKey"></xsl:value-of>
				</xsl:with-param>
			</xsl:call-template>
		</p>
	</xsl:template>

	<xsl:template name="part2:categoryOfInvestmentDesc">
		<p>Brief description: (optional):
			<xsl:call-template name="OutputOptional">
				<xsl:with-param name="value">
					<xsl:value-of select="./part2:categoryOfInvestmentDesc"></xsl:value-of>
				</xsl:with-param>
			</xsl:call-template>
		</p>
	</xsl:template>

	<xsl:template match="part2:RAN">
		<td><p><xsl:apply-templates/></p></td>
	</xsl:template>

	<xsl:template match="part2:R">
		<td><p><xsl:apply-templates/></p></td>
	</xsl:template>

	<xsl:template match="part2:NRSROSRating|part2:NRSRORating">
		<xsl:apply-templates/>
	</xsl:template>

	<xsl:template match="part2:NRSRORatingList">
		<xsl:for-each select="part2:NRSROSRating">
			<tr>
			<xsl:if test="position() = 1">
				<td>
					<xsl:attribute name="rowspan"><xsl:value-of select="count(../part2:NRSROSRating)"/></xsl:attribute>
					<p><xsl:value-of select="../../part2:InvestmentIssuer"/></p>
				</td>
			</xsl:if>
			<xsl:apply-templates/>
			</tr>
		</xsl:for-each>
	</xsl:template>

	<xsl:template match="part2:demandFeatureIssuer">
		<xsl:apply-templates/>
	</xsl:template>

	<xsl:template match="part2:demandFeatureIssuerList">
		<table>
			<col />
			<col />
			<col />
			<tr>
				<th>
					<p>Demand Feature issuer</p>
				</th>
				<th>
					<p>Designated NRSRO(s) for the Demand Feature or provider of the Demand Feature</p>
				</th>
				<th>
					<p>Credit rating of the Demand Feature issuer</p>
				</th>
			</tr>
			<xsl:apply-templates/>
		</table>
	</xsl:template>

	<xsl:template match="part2:doesSecurityHaveDemandFeature">
		<p>Item 37. Does the security have a Demand Feature? 
			<xsl:call-template name="BooleanOutput">
				<xsl:with-param name="value">
					<xsl:value-of select="." />
				</xsl:with-param>
			</xsl:call-template>		
		</p>
		<xsl:if test=". = 'Y' or . = 'y'">
			<xsl:apply-templates select="../part2:demandFeatureIssuerList"/>
		</xsl:if>
	</xsl:template>

	<xsl:template match="part2:designatedNRSRO">
		<tr>
			<td>
				<p><xsl:value-of select="./part2:RAN"/></p>
			</td>
			<td>
				<p><xsl:value-of select="./part2:R"/></p>
			</td>
		</tr>
	</xsl:template>
	
	<xsl:template name="part2:designatedNRSROList">
		<p>Item 34. Name of each Designated NRSRO:</p>
		<table>
			<col />
			<col />
			<tr>
				<th>
					<p>Name of Designated NRSRO</p>
				</th>
				<th>
					<p>Credit rating given by the Designated NRSRO</p>
				</th>
			</tr>
			<xsl:apply-templates select="./part2:designatedNRSROList/part2:designatedNRSRO"/>
		</table>
	</xsl:template>

	<xsl:template match="part2:guarantor">
		<tr>
			<xsl:for-each select="part2:NRSRORatingList/part2:NRSRORating">
				<xsl:if test="position() = 1">
					<td>
						<xsl:attribute name="rowspan"><xsl:value-of select="count(../part2:NRSRORating)"/></xsl:attribute>
						<p><xsl:value-of select="../../part2:O"/></p>
					</td>
				</xsl:if>
				<xsl:apply-templates/>
			</xsl:for-each> 
		</tr>
	</xsl:template>

	<xsl:template match="part2:guarantorList">
		<table>
			<col />
			<col />
			<col />
			<tr>
				<th>
					<p>Guarantor</p>
				</th>
				<th>
					<p>Designated NRSRO(s) for the Guarantee or Guarantor</p>
				</th>
				<th>
					<p>Credit rating of the Guarantor</p>
				</th>
			</tr>
			<xsl:apply-templates/>
		</table>
	</xsl:template>

	<xsl:template match="part2:doesSecurityHaveGuarantee">
		<p>Item 38. Does the security have a Guarantee?				
			<xsl:call-template name="BooleanOutput">
				<xsl:with-param name="value">
					<xsl:value-of select="." />
				</xsl:with-param>
			</xsl:call-template>		
		</p>

		<xsl:if test=". = 'Y' or . = 'y'">
			<xsl:apply-templates select="../part2:guarantorList"/>
		</xsl:if>
	</xsl:template>

	<xsl:template match="part2:enhancement">
		<tr>
			<xsl:for-each select="part2:enhancementProviderList/part2:Provider">
				<xsl:if test="position() = 1">
					<td>
						<xsl:attribute name="rowspan"><xsl:value-of select="count(..//part2:Provider) + count(..//part2:NRSRORatingList/part2:NRSRORating)"/></xsl:attribute>
						<p><xsl:value-of select="../../part2:typeOfEnhancement"/></p>
					</td>
				</xsl:if>
				<xsl:for-each select="./part2:NRSRORatingList">
					<xsl:if test="position() = 1">
						<td>
							<xsl:attribute name="rowspan"><xsl:value-of select="count(part2:NRSRORating)"/></xsl:attribute>
							<xsl:value-of select="../part2:enhancementProvider"/>
						</td>
					</xsl:if>
					<xsl:apply-templates/>
				</xsl:for-each>
			</xsl:for-each> 
		</tr>
	</xsl:template>

	<xsl:template match="part2:enhancementsList">
		<table>
			<col />
			<col />
			<col />
			<col />
			<tr>
				<th>
					<p>Type of enhancement</p>
				</th>
				<th>
					<p>Enhancement provider</p>
				</th>
				<th>
					<p>Designated NRSRO(s) for the enhancement or the enhancement provider</p>
				</th>
				<th>
					<p>Credit rating of the enhancement provider</p>
				</th>
			</tr>
			<xsl:apply-templates/>
		</table>
	</xsl:template>

	<xsl:template match="part2:doesSecurityHaveEnhancementsOnWhichFundRelying">
		<p>Item 39. Does the security have any enhancements, other than those identified in Items 37 and 38 above, on which the fund is relying to determine the quality, maturity or liquidity of the security? 
			<xsl:call-template name="BooleanOutput">
				<xsl:with-param name="value">
					<xsl:value-of select="." />
				</xsl:with-param>
			</xsl:call-template>		
		</p>
		
		<xsl:if test=". = 'Y' or . = 'y'">
			<xsl:apply-templates select="../part2:enhancementsList"/>
		</xsl:if>
	</xsl:template>

	<xsl:template match="part2:scheduleOfPortfolioSecurities">
		<div class="security">
			<p class="heading2">Security</p>
			<p>Item 26. The name of the issuer: <xsl:value-of select="./part2:InvestmentIssuer"/></p>
			<p>Item 27. The title of the issue (including coupon or yield): <xsl:value-of select="./part2:InvestmentTitle"/></p>
			<xsl:call-template name="part2:CUSIPMember" />
			<xsl:call-template name="part2:InvestmentIdentifier" />
			<xsl:call-template name="part2:EntityCentralIndexKey" />
			<p>Item 31. The category of investment: <xsl:value-of select="./part2:InvestmentTypeDomain"/></p>
			<blockquote class="categorydesc">
				<xsl:call-template name="part2:categoryOfInvestmentDesc"/>
			</blockquote>
			<xsl:call-template name="part2:isFundTreatingAsAcquisitionUnderlyingSecurities"/>
			<p>Item 33. Rating: <xsl:value-of select="./part2:rating"/></p>
			<xsl:call-template name="part2:designatedNRSROList" />
			<p>Item 35. Maturity date as determined under rule 2a-7: <xsl:value-of select="./part2:InvestmentMaturityDate"/></p>
			<p>Item 36. The final legal maturity date: <xsl:value-of select="./part2:InvestmentMaturityDate"/></p>
			<xsl:apply-templates select="./part2:doesSecurityHaveDemandFeature"/>
			<xsl:apply-templates select="./part2:doesSecurityHaveGuarantee"/>
			<xsl:apply-templates select="./part2:doesSecurityHaveEnhancementsOnWhichFundRelying"/>
			<p>Item 40. Total principal amount of the security held by the series: <xsl:value-of select="format-number(./part2:InvestmentOwnedBalancePrincipalAmount, '$##,###,###,###,###.##')"/></p>
			<p>Item 41. Total current amortized cost: <xsl:value-of select="format-number(./part2:AvailableForSaleSecuritiesAmortizedCost, '$##,###,###,###,###.##')"/></p>
			<p>Item 42. The percentage of the money market fund's net assets invested in the security:
            <xsl:value-of select="format-number(./part2:InvestmentOwnedPercentOfNetAssets, '##.###%')"/>
			</p>
			<p>Item 43. Explanatory notes: <xsl:value-of select="./part2:InvestmentOwnedInvestmentAdditionalInformation"/></p>
			<p>Item 44. Is this an Illiquid Security as of the date of this report?
				<xsl:call-template name="BooleanOutput">
					<xsl:with-param name="value">
						<xsl:value-of select="./part2:isThisIlliquidSecurity" />
					</xsl:with-param>
				</xsl:call-template>		
			</p>
			<p>Item 45. The value of the security, calculated using available market quotations (or an appropriate substitute that reflects current market conditions), including the value of any capital support agreement:
				<xsl:value-of select="format-number(./part2:InvestmentOwnedAtFairValue, '$##,###,###,###,###.##')"/> 
			</p>
			<p>Item 46. The value of the security, calculated using available market quotations (or an appropriate substitute that reflects current market conditions), excluding the value of any capital support agreement: 
				<xsl:value-of select="format-number(./part2:valueOfSecurityExcludingValueOfCapitalSupportAgreement, '$##,###,###,###,###.##')"/> 
			</p>
		</div>
	</xsl:template>

	<xsl:template match="n1:scheduleOfPortfolioSecuritiesList">
		<p class="heading1">Part 2 - Schedule of Portfolio Securities</p>
		<xsl:apply-templates select="./part2:scheduleOfPortfolioSecurities"/>
	</xsl:template>

	<xsl:template match="*">
	</xsl:template>

	<xsl:template name="OutputOptional">
		<xsl:param name="value"/>
		
		<xsl:choose>
			<xsl:when test="string-length($value) > 0">
				<xsl:value-of select="$value"/>
			</xsl:when>
			<xsl:otherwise>
				<span class="notprovided">
					[Not Provided]
				</span>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="DateToMonthNameLong">
		<xsl:param name="sDate" />
		<xsl:variable name="nMonth" select="number(substring($sDate, 6, 2))" />
		<xsl:choose>
			<xsl:when test="$nMonth = 1">
				January
			</xsl:when>
			<xsl:when test="$nMonth = 2">
				February
			</xsl:when>
			<xsl:when test="$nMonth = 3">
				March
			</xsl:when>
			<xsl:when test="$nMonth = 4">
				April
			</xsl:when>
			<xsl:when test="$nMonth = 5">
				May
			</xsl:when>
			<xsl:when test="$nMonth = 6">
				June
			</xsl:when>
			<xsl:when test="$nMonth = 7">
				July
			</xsl:when>
			<xsl:when test="$nMonth = 8">
				August
			</xsl:when>
			<xsl:when test="$nMonth = 9">
				September
			</xsl:when>
			<xsl:when test="$nMonth = 10">
				October
			</xsl:when>
			<xsl:when test="$nMonth = 11">
				November
			</xsl:when>
			<xsl:otherwise>
				December
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
</xsl:stylesheet>